import keras.preprocessing.text
import numpy as np
import pandas as pd
np.random.seed(1337)  # for reproducibility
from keras.preprocessing import sequence
from keras.models import Sequential
from keras.layers.core import Dense, Activation
from keras.layers.embeddings import Embedding
from keras.layers.recurrent import LSTM
from sklearn.metrics import (precision_score, recall_score,f1_score, accuracy_score,mean_squared_error,mean_absolute_error)
from sklearn import metrics
from sklearn.metrics import roc_auc_score


print("Loading")

#traindata = pd.read_csv('CDMC2016_AndroidLabel.Train.csv', header=None)
#testdata = pd.read_csv('CDMC2016_AndroidPermissions.Test.csv', header=None)

traindata = pd.read_csv('space/CDMC2016_AndroidLabel.Train.csv', header=None)
testdata = pd.read_csv('space/CDMC2016_AndroidPermissions.Test.csv', header=None)

x = traindata.iloc[:,1]
y = traindata.iloc[:,0]
t = testdata.iloc[:,0]


tk = keras.preprocessing.text.Tokenizer(nb_words=500,filters=keras.preprocessing.text.base_filter(), lower=True, split=" ")
tk.fit_on_texts(x)

x = tk.texts_to_sequences(x)
print(x)
'''
tk = keras.preprocessing.text.Tokenizer(nb_words=500, filters=keras.preprocessing.text.base_filter(), lower=True, split=" ")
tk.fit_on_texts(t)
t = tk.texts_to_sequences(t)
print(t)
'''
'''
max_len = 200
print "max_len ", max_len
print('Pad sequences (samples x time)')

x = sequence.pad_sequences(x, maxlen=max_len)
t = sequence.pad_sequences(t, maxlen=max_len)

max_features = 500

model = Sequential()
print('Build model...')

model = Sequential()
model.add(Embedding(max_features, 128, input_length=max_len, dropout=0.1))
model.add(LSTM(128, dropout_W=0.1, dropout_U=0.1))
model.add(Dense(1))
model.add(Activation('sigmoid'))

model.compile(loss='binary_crossentropy', optimizer='adam',metrics=['accuracy'])
model.fit(x, y, batch_size=32, nb_epoch=30)
score, acc = model.evaluate(x, y, batch_size=32)
print('Test score:', score)
print('Test accuracy:', acc)

y_pred = model.predict_classes(t)

np.savetxt('output.txt', y_pred, fmt='%01d')



'''
